/*
CoHelper.ahk
*/

VTable(ppv, idx)
{
   ptr := (*ppv | *++ppv << 8 | *++ppv << 16 | *++ppv << 24) + 4*idx
   Return  *ptr | *++ptr << 8 | *++ptr << 16 | *++ptr << 24
}

QueryInterface(ppv, ByRef IID)
{
   If   StrLen(IID) = 38
   GUID4String(IID, IID)
   DllCall(VTable(ppv,0), "Uint", ppv, "str", IID, "UintP", ppv)
   Return ppv
}

AddRef(ppv)
{
   Return DllCall(VTable(ppv,1), "Uint", ppv)
}

Release(ppv)
{
   Return DllCall(VTable(ppv,2), "Uint", ppv)
}

QueryService(ppv, ByRef SID, ByRef IID)
{
   If   StrLen(SID) = 38
   GUID4String(SID, SID)
   If   StrLen(IID) = 38
   GUID4String(IID, IID)
   GUID4String(IID_IServiceProvider, "{6D5140C1-7436-11CE-8034-00AA006009FA}")
   DllCall(VTable(ppv,0), "Uint", ppv, "str", IID_IServiceProvider, "UintP", psp)
   DllCall(VTable(psp,3), "Uint", psp, "str", SID, "str", IID, "UintP", ppv)
   DllCall(VTable(psp,2), "Uint", psp)
   Return ppv
}

GetIDispatch(pdisp, LCID = 0)
{
   DllCall(VTable(pdisp, 4), "Uint", pdisp, "Uint", 0, "Uint", LCID, "UintP", pinfo)
   If !pinfo
   Return
   DllCall(VTable(pinfo, 3), "Uint", pinfo, "UintP", pattr)
   IDispatch := String4GUID(pattr)
   DllCall(VTable(pinfo,19), "Uint", pinfo, "Uint" , pattr)
   DllCall(VTable(pinfo, 2), "Uint", pinfo)
   Return IDispatch
}

Ansi2Unicode(ByRef sString, ByRef wString, nLen = 0)
{
   If !nLen
       nLen := DllCall("MultiByteToWideChar", "Uint", 0, "Uint", 0, "Uint", &sString, "int", -1, "Uint", 0, "int", 0)
   VarSetCapacity(wString, nLen * 2 + 1)
   DllCall("MultiByteToWideChar", "Uint", 0, "Uint", 0, "Uint", &sString, "int", -1, "Uint", &wString, "int", nLen)
}

Unicode2Ansi(ByRef wString, ByRef sString, nLen = 0)
{
   pString := wString + 0 > 65535 ? wString : &wString
   If !nLen
       nLen := DllCall("WideCharToMultiByte", "Uint", 0, "Uint", 0, "Uint", pString, "int", -1, "Uint", 0, "int", 0, "Uint", 0, "Uint", 0)
   VarSetCapacity(sString, nLen)
   DllCall("WideCharToMultiByte", "Uint", 0, "Uint", 0, "Uint", pString, "int", -1, "str", sString, "int", nLen, "Uint", 0, "Uint", 0)
}

CLSID4ProgID(Byref CLSID, sProgID)
{
   VarSetCapacity(CLSID, 16)
   Ansi2Unicode(sProgID, wProgID)
   DllCall("ole32\CLSIDFromProgID", "str", wProgID, "str", CLSID)
}

GUID4String(Byref CLSID, sString)
{
   VarSetCapacity(CLSID, 16)
   Ansi2Unicode(sString, wString, 38)
   DllCall("ole32\CLSIDFromString", "str", wString, "str", CLSID)
}

String4GUID(Byref CLSID)
{
   VarSetCapacity(wString, 38 * 2 + 1)
   DllCall("ole32\StringFromGUID2", "str", CLSID, "str", wString, "int", 38 + 1)
   Unicode2Ansi(wString, sString, 38)
   Return sString
}

CreateObject(ByRef CLSID, ByRef IID, CLSCTX = 5)
{
   If   StrLen(CLSID)  =  38
   GUID4String(CLSID, CLSID)
   If   StrLen(IID) = 38
   GUID4String(IID, IID)
   DllCall("ole32\CoCreateInstance", "str", CLSID, "Uint", 0, "Uint", CLSCTX, "str", IID, "UintP", ppv)
   Return ppv
}

ActiveXObject(ProgID, CLSCTX = 5)
{
   InStr(ProgID, "{") ? GUID4String(CLSID, ProgID) : CLSID4ProgID(CLSID, ProgID)
   GUID4String(IID_IDispatch, "{00020400-0000-0000-C000-000000000046}")
   DllCall("ole32\CoCreateInstance", "str", CLSID, "Uint", 0, "Uint", CLSCTX, "str", IID_IDispatch, "UintP", pdisp)
   Return pdisp
}

GetObject(Moniker)
{
   Ansi2Unicode(Moniker, wMoniker)
   GUID4String(IID_IDispatch, "{00020400-0000-0000-C000-000000000046}")
   DllCall("ole32\CoGetObject", "str", wMoniker, "Uint", 0, "str", IID_IDispatch, "UintP", pdisp)
   Return pdisp
}

GetActiveObject(ProgID)
{
   InStr(ProgID, "{") ? GUID4String(CLSID, ProgID) : CLSID4ProgID(CLSID, ProgID)
   GUID4String(IID_IDispatch, "{00020400-0000-0000-C000-000000000046}")
   DllCall("oleaut32\GetActiveObject", "str", CLSID, "Uint", 0, "UintP", punk)
   DllCall(VTable(punk,0), "Uint", punk, "str", IID_IDispatch, "UintP", pdisp)
   DllCall(VTable(punk,2), "Uint", punk)
   Return pdisp
}

SysAllocString(sString)
{
   Ansi2Unicode(sString, wString)
   Return DllCall("oleaut32\SysAllocString", "str", wString)
}

SysFreeString(pString)
{
   Return DllCall("oleaut32\SysFreeString", "Uint", pString)
}

CoTaskMemAlloc(cb)
{
   Return DllCall("ole32\CoTaskMemAlloc", "Uint", cb)
}

CoTaskMemFree(pv)
{
   Return DllCall("ole32\CoTaskMemFree", "Uint", pv)
}

CoCreateGuid()
{
   VarSetCapacity(GUID, 16)
   DllCall("ole32\CoCreateGuid", "Uint", &GUID)
   Return String4GUID(GUID)
}

CoInitialize()
{
   DllCall("ole32\CoInitialize", "Uint", 0)
}

CoUninitialize()
{
   DllCall("ole32\CoUninitialize")
}

OleInitialize()
{
   DllCall("ole32\OleInitialize", "Uint", 0)
}

OleUninitialize()
{
   DllCall("ole32\OleUninitialize")
}

DecodeInteger(ref, nSize = 4)
{
   DllCall("RtlMoveMemory", "int64P", val, "Uint", ref, "Uint", nSize)
   Return val
}

EncodeInteger(ref, val, nSize = 4)
{
   DllCall("RtlMoveMemory", "Uint", ref, "int64P", val, "Uint", nSize)
}

DecodeReal(ref, nSize = 4)
{
   DllCall("RtlMoveMemory", nSize = 4 ? "floatP" : "doubleP", val, "Uint", ref, "Uint", nSize)
   Return val
}

EncodeReal(ref, val, nSize = 4)
{
   DllCall("RtlMoveMemory", "Uint", ref, nSize = 4 ? "floatP" : "doubleP", val, "Uint", nSize)
}
